<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->renameColumn('date_datetime', 'event_datetime');
        });
        Schema::table('amazon_fba_report_removal_shipments', function (Blueprint $table) {
            $table->renameColumn('shipment_date_datetime', 'event_datetime');
        });
        Schema::table('amazon_fba_report_shipments', function (Blueprint $table) {
            $table->renameColumn('reporting_date_datetime', 'event_datetime');
        });
        Schema::table('amazon_fba_report_customer_returns', function (Blueprint $table) {
            $table->dateTime('event_datetime')->after('return_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->renameColumn('event_datetime', 'date_datetime');
        });
        Schema::table('amazon_fba_report_removal_shipments', function (Blueprint $table) {
            $table->renameColumn('event_datetime', 'shipment_date_datetime');
        });
        Schema::table('amazon_fba_report_shipments', function (Blueprint $table) {
            $table->renameColumn('event_datetime', 'reporting_date_datetime');
        });
        Schema::table('amazon_fba_report_customer_returns', function (Blueprint $table) {
            $table->dropColumn('event_datetime');
        });
    }
};
