<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_products', function (Blueprint $table) {
            $table->dropColumn('price');
        });
        Schema::table('amazon_products', function (Blueprint $table) {
            $table->decimal('price', 12, 4)->storedAs("IF(json_unquote(json_extract(`json_object`,'$.price')) = '', 0, json_unquote(json_extract(`json_object`,'$.price')))")->after('seller_sku');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
    }
};
