<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_products', function (Blueprint $table) {
            $table->string('open_date')->after('browse_classification')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.open_date'))");
            $table->string('style')->after('open_date')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.summaries[0].style'))");
            $table->string('size')->after('style')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.summaries[0].size'))");
            $table->string('item_length')->after('size')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].item.length.value'))");
            $table->string('item_width')->after('item_length')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].item.width.value'))");
            $table->string('item_height')->after('item_width')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].item.height.value'))");
            $table->string('item_dimensions_unit')->after('item_height')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].item.length.unit'))");
            $table->string('item_weight')->after('item_dimensions_unit')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].item.weight.value'))");
            $table->string('item_weight_unit')->after('item_weight')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].item.weight.unit'))");
            $table->string('number_of_items')->after('item_weight_unit')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.attributes.number_of_items[0].value'))");
            $table->string('department')->after('number_of_items')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.attributes.department[0].value'))");
            $table->string('item_type_name')->after('department')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.attributes.item_type_name[0].value'))");
            $table->string('material')->after('item_type_name')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.attributes.material[0].value'))");
            $table->string('item_type_keyword')->after('item_type_name')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.attributes.item_type_keyword[0].value'))");
            $table->string('packageQuantity')->after('item_type_keyword')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.summaries[0].packageQuantity'))");
            $table->string('listing_id')->after('packageQuantity')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.listing_id'))");
            $table->text('item_description')->after('listing_id')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.item_description'))");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_products', function (Blueprint $table) {
            $table->dropColumn('open_date');
            $table->dropColumn('style');
            $table->dropColumn('size');
            $table->dropColumn('item_length');
            $table->dropColumn('item_width');
            $table->dropColumn('item_height');
            $table->dropColumn('item_dimensions_unit');
            $table->dropColumn('item_weight');
            $table->dropColumn('item_weight_unit');
            $table->dropColumn('number_of_items');
            $table->dropColumn('department');
            $table->dropColumn('item_type_name');
            $table->dropColumn('material');
            $table->dropColumn('item_type_keyword');
            $table->dropColumn('packageQuantity');
            $table->dropColumn('item_description');
            $table->dropColumn('listing_id');
        });
    }
};
