<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        /*
         * Do we want to indicate a field for summary by?  It depends on if we always get daily summaries or if we
         * can get weekly/monthly summaries
         */
        Schema::create('amazon_fba_report_inventory_ledger_summaries', function (Blueprint $table) {
            $table->id();
            $table->text('checksum')->nullable();
            $table->foreignId('integration_instance_id')->index('instance_id_foreign');
            $table->foreignId('amazon_report_id')->constrained()->index('report_id_foreign');
            $table->foreignId('amazon_product_id')->nullable()->constrained()->index('product_id_foreign');
            $table->foreignId('fifo_layer_id')->nullable()->constrained()->index('fifo_layer_id_foreign');
            $table->timestamp('sku_product_initialized_at')->nullable();
            $table->string('date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.date'))");
            $table->string('fnsku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fnsku'))");
            $table->string('asin')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.asin'))");
            $table->string('msku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.msku'))");
            $table->string('title')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.title'))");
            $table->string('disposition')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.disposition'))");
            $table->integer('starting_warehouse_balance')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.starting_warehouse_balance'))");
            $table->integer('in_transit_between_warehouses')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.in_transit_between_warehouses'))");
            $table->integer('receipts')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.receipts'))");
            $table->integer('customer_shipments')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.customer_shipments'))");
            $table->integer('customer_returns')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.customer_returns'))");
            $table->integer('vendor_returns')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.vendor_returns'))");
            $table->integer('warehouse_transfer_in_out')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.warehouse_transfer_in_out'))");
            $table->integer('found')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.found'))");
            $table->integer('lost')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.lost'))");
            $table->integer('damaged')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.damaged'))");
            $table->integer('disposed')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.disposed'))");
            $table->integer('other_events')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.other_events'))");
            $table->integer('ending_warehouse_balance')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ending_warehouse_balance'))");
            $table->integer('unknown_events')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.unknown_events'))");
            $table->string('location')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.location'))");
            $table->json('json_object');
            $table->index(['integration_instance_id', 'msku'], 'msku_index');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_report_inventory_ledger_summaries');
    }
};
