<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_shipment_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afset_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afset_amazon_financial_event_group_index');
            $table->string('AmazonOrderId')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.AmazonOrderId"))');
            $table->string('SellerOrderId')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.SellerOrderId"))');
            $table->string('MarketplaceName')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.MarketplaceName"))');
            $table->string('PostedDate')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.PostedDate"))');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_shipment_events');
    }
};
