<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('amazon_financial_adjustment_events', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->constrained()->index('afaet_integration_instance_id_index');
            $table->foreignId('amazon_financial_event_group_id')->constrained()->index('afaet_amazon_financial_event_group_index');
            $table->string('AdjustmentType')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.AdjustmentType"))');
            $table->string('PostedDate')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.PostedDate"))');
            $table->decimal('CurrencyAmount', 10, 2)->storedAs('json_extract(json_object, "$.AdjustmentAmount.CurrencyAmount")');
            $table->string('CurrencyCode')->storedAs('JSON_UNQUOTE(json_extract(json_object, "$.AdjustmentAmount.CurrencyCode"))');
            $table->json('json_object');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('amazon_financial_adjustment_events');
    }
};
