<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_feed_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index()->constrained('integration_instances');
            $table->string('feedType');
            $table->json('marketplaceIds')->nullable();
            $table->json('feedOptions')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_feed_requests');
    }
};
