<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_feed_submissions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index()->constrained('integration_instances');
            $table->string('feedId')->unique()->nullable();
            $table->string('feedType')->nullable();
            $table->json('marketplaceIds')->nullable();
            $table->string('inputFeedDocumentId')->nullable();
            $table->json('feedOptions')->nullable();
            $table->string('createdTime')->nullable();
            $table->string('processingStatus')->nullable();
            $table->string('processingStartTime')->nullable();
            $table->string('processingEndTime')->nullable();
            $table->string('resultFeedDocumentId')->nullable();
            $table->string('url')->nullable();
            $table->string('compressionAlgorithm')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_feed_submissions');
    }
};
