<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->unsignedBigInteger('sku_link_id')->nullable()->after('integration_instance_id');
            $table->string('sku_link_type')->nullable()->after('sku_link_id');
            $table->unique(['sku_link_id', 'sku_link_type'], 'sku_link_id_sku_link_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->dropUnique(['sku_link_id', 'sku_link_type']);
            $table->dropColumn('sku_link_id');
            $table->dropColumn('sku_link_type');
        });
    }
};
