<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->unsignedBigInteger('detail_id')->nullable()->after('integration_instance_id');
            $table->string('detail_type')->nullable()->after('detail_id');
            $table->index(['detail_id', 'detail_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_fba_report_inventory_ledger', function (Blueprint $table) {
            $table->dropIndex(['detail_id', 'detail_type']);
            $table->dropColumn('detail_id');
            $table->dropColumn('detail_type');
        });
    }
};
