<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_orders', function (Blueprint $table) {
            foreach (['LatestShipDate', 'EarliestShipDate', 'EarliestDeliveryDate', 'LatestDeliveryDate', 'PurchaseDate'] as $dateColumn) {
                $table->dateTime($dateColumn.'Utc')->storedAs("STR_TO_DATE(JSON_UNQUOTE(json_extract(json_object,'$.".$dateColumn."Utc')),'%Y-%m-%d %H:%i:%s')")->nullable()->after($dateColumn);
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_orders', function (Blueprint $table) {
            foreach (['LatestShipDate', 'EarliestShipDate', 'EarliestDeliveryDate', 'LatestDeliveryDate', 'PurchaseDate'] as $dateColumn) {
                $table->dropColumn($dateColumn.'Utc');
            }
        });
    }
};
