<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_products', function (Blueprint $table) {
            $table->dateTime('catalog_data_last_sync')->nullable()->after('website_group_name');
            $table->boolean('was_catalog_data_sync_attempted')->default(0)->after('catalog_data_last_sync');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_products', function (Blueprint $table) {
            $table->dropColumn('catalog_data_last_sync');
            $table->dropColumn('was_catalog_data_sync_attempted');
        });
    }
};
