<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fba_inbound_shipment_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_fba_inbound_shipment_id')->index('amazon_fba_inbound_shipment_id_index');
            $table->string('SellerSKU')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.SellerSKU'))");
            $table->string('FulfillmentNetworkSKU')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.FulfillmentNetworkSKU'))");
            $table->integer('QuantityShipped')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.QuantityShipped'))");
            $table->integer('QuantityReceived')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.QuantityReceived'))");
            $table->integer('QuantityInCase')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.QuantityInCase'))");
            $table->string('ReleaseDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ReleaseDate'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_inbound_shipment_items');
    }
};
