<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fba_report_inventory', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index();
            $table->string('sku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sku'))");
            $table->string('fnsku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fnsku'))");
            $table->string('product_name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.product_name'))");
            $table->string('condition')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.condition'))");
            $table->string('your_price')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.your_price'))");
            $table->string('mfn_listing_exists')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.mfn_listing_exists'))");
            $table->integer('mfn_fulfillable_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.mfn_fulfillable_quantity'))");
            $table->string('afn_listing_exists')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_listing_exists'))");
            $table->string('afn_warehouse_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_warehouse_quantity'))");
            $table->integer('afn_fulfillable_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_fulfillable_quantity'))");
            $table->integer('afn_unsellable_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_unsellable_quantity'))");
            $table->integer('afn_reserved_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_reserved_quantity'))");
            $table->integer('afn_total_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_total_quantity'))");
            $table->float('per_unit_volume', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.per_unit_volume'))");
            $table->integer('afn_inbound_working_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_inbound_working_quantity'))");
            $table->integer('afn_inbound_shipped_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_inbound_shipped_quantity'))");
            $table->integer('afn_inbound_receiving_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_inbound_receiving_quantity'))");
            $table->integer('afn_researching_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_researching_quantity'))");
            $table->integer('afn_reserved_future_supply')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_reserved_future_supply'))");
            $table->integer('afn_future_supply_buyable')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.afn_future_supply_buyable'))");
            $table->json('json_object');
            $table->unique(['integration_instance_id', 'sku']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_report_inventory');
    }
};
