<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fulfillment_return_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_fulfillment_shipment_item_id')->index('fulfillmentShipmentItemIndex');
            $table->string('sellerReturnId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sellerReturnId'))");
            $table->string('sellerFulfillmentOrderItemId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sellerFulfillmentOrderItemId'))");
            $table->string('amazonShipmentId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.amazonShipmentId'))");
            $table->string('sellerReturnReasonCode')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sellerReturnReasonCode'))");
            $table->string('returnComment')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.returnComment'))");
            $table->string('amazonReturnReasonCode')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.amazonReturnReasonCode'))");
            $table->string('status')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.status'))");
            $table->string('statusChangedDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.statusChangedDate'))");
            $table->string('returnAuthorizationId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.returnAuthorizationId'))");
            $table->string('returnReceivedCondition')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.returnReceivedCondition'))");
            $table->string('fulfillmentCenterId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillmentCenterId'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fulfillment_return_items');
    }
};
