<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fulfillment_return_authorizations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_fulfillment_order_id')->index('fulfillmentOrderIndex');
            $table->string('returnAuthorizationId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.returnAuthorizationId'))");
            $table->string('fulfillmentCenterId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillmentCenterId'))");
            $table->json('returnToAddress')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.returnToAddress'))");
            $table->string('amazonRmaId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.amazonRmaId'))");
            $table->string('rmaPageURL')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.rmaPageURL'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fulfillment_return_authorizations');
    }
};
