<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fulfillment_shipment_packages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_fulfillment_shipment_id')->index('fulfillmentShipmentIndex');
            $table->integer('packageNumber')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.packageNumber'))");
            $table->string('carrierCode')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.carrierCode'))");
            $table->string('trackingNumber')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.trackingNumber'))");
            $table->string('estimatedArrivalDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.estimatedArrivalDate'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fulfillment_shipment_packages');
    }
};
