<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fulfillment_shipment_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_fulfillment_shipment_id')->index('fulfillmentShipmentIndex');
            $table->string('sellerSku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sellerSku'))");
            $table->string('sellerFulfillmentOrderItemId')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sellerFulfillmentOrderItemId'))");
            $table->integer('quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.quantity'))");
            $table->integer('packageNumber')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.packageNumber'))");
            $table->string('serialNumber')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.serialNumber'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fulfillment_shipment_items');
    }
};
