<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fulfillment_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index('integrationInstanceIndex');
            $table->string('sellerFulfillmentOrderId');
            $table->string('marketplaceId');
            $table->string('displayableOrderId');
            $table->string('displayableOrderDate');
            $table->string('displayableOrderComment');
            $table->string('shippingSpeedCategory');
            $table->string('deliveryWindow');
            $table->json('destinationAddress');
            $table->string('fulfillmentAction');
            $table->string('fulfillmentPolicy');
            $table->json('codSettings');
            $table->string('receivedDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.receivedDate'))");
            $table->string('fulfillmentOrderStatus')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillmentOrderStatus'))");
            $table->string('statusUpdatedDate')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.statusUpdatedDate'))");
            $table->json('notificationEmails');
            $table->json('featureConstraints');
            $table->json('json_object')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fulfillment_orders');
    }
};
