<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fba_report_removal_shipments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index('integrationInstanceIndex');
            $table->string('request_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.request_date'))");
            $table->string('order_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.order_id'))");
            $table->string('shipment_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipment_date'))");
            $table->string('sku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sku'))");
            $table->string('fnsku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fnsku'))");
            $table->string('disposition')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.disposition'))");
            $table->integer('shipped_quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipped_quantity'))");
            $table->string('carrier')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.carrier'))");
            $table->string('tracking_number')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.tracking_number'))");
            $table->string('removal_order_type')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.removal_order_type'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_report_removal_shipments');
    }
};
