<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fba_report_shipments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index();
            $table->string('amazon_order_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.amazon_order_id'))");
            $table->string('merchant_order_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.merchant_order_id'))");
            $table->string('shipment_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipment_id'))");
            $table->string('shipment_item_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipment_item_id'))");
            $table->string('amazon_order_item_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.amazon_order_item_id'))");
            $table->string('merchant_order_item_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.merchant_order_item_id'))");
            $table->string('purchase_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.purchase_date'))");
            $table->string('payments_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.payments_date'))");
            $table->string('shipment_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipment_date'))");
            $table->string('reporting_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.reporting_date'))");
            $table->string('buyer_name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.buyer_name'))");
            $table->string('buyer_phone_number')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.buyer_phone_number'))");
            $table->string('sku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sku'))");
            $table->string('product_name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.product_name'))");
            $table->string('quantity_shipped')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.quantity_shipped'))");
            $table->string('currency')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.currency'))");
            $table->float('item_price', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.item_price'))");
            $table->float('item_tax', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.item_tax'))");
            $table->float('shipping_price', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipping_price'))");
            $table->float('shipping_tax', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.shipping_tax'))");
            $table->float('gift_wrap_price', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.gift_wrap_price'))");
            $table->float('gift_wrap_tax', 12, 4)->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.gift_wrap_tax'))");
            $table->string('ship_service_level')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ship_service_level'))");
            $table->string('recipient_name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.recipient_name'))");
            $table->string('ship_address_1')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ship_address_1'))");
            $table->string('ship_address_2')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ship_address_2'))");
            $table->string('ship_address_3')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ship_address_3'))");
            $table->string('ship_city')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ship_city'))");
            $table->string('ship_state')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ship_state'))");
            $table->string('ship_postal_code')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ship_postal_code'))");
            $table->string('ship_country')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ship_country'))");
            $table->string('ship_phone_number')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ship_phone_number'))");
            $table->string('bill_address_1')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.bill_address_1'))");
            $table->string('bill_address_2')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.bill_address_2'))");
            $table->string('bill_address_3')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.bill_address_3'))");
            $table->string('bill_city')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.bill_city'))");
            $table->string('bill_state')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.bill_state'))");
            $table->string('bill_postal_code')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.bill_postal_code'))");
            $table->string('bill_country')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.bill_country'))");
            $table->string('item_promotion_discount')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.item_promotion_discount'))");
            $table->string('ship_promotion_discount')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.ship_promotion_discount'))");
            $table->string('carrier')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.carrier'))");
            $table->string('tracking_number')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.tracking_number'))");
            $table->string('estimated_arrival_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.estimated_arrival_date'))");
            $table->string('fulfillment_center_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillment_center_id'))");
            $table->string('fulfillment_channel')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillment_channel'))");
            $table->string('sales_channel')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sales_channel'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_report_shipments');
    }
};
