<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_fba_report_customer_returns', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index();
            $table->string('return_date')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.return_date'))");
            $table->string('order_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.order_id'))");
            $table->string('sku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.sku'))");
            $table->string('asin')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.asin'))");
            $table->string('fnsku')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fnsku'))");
            $table->string('product_name')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.product_name'))");
            $table->integer('quantity')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.quantity'))");
            $table->string('fulfillment_center_id')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.fulfillment_center_id'))");
            $table->string('detailed_disposition')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.detailed_disposition'))");
            $table->string('reason')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.reason'))");
            $table->string('status')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.status'))");
            $table->string('license_plate_number')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.license_plate_number'))");
            $table->string('customer_comments')->storedAs("JSON_UNQUOTE(JSON_EXTRACT(json_object, '$.customer_comments'))");
            $table->json('json_object');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_fba_report_customer_returns');
    }
};
