<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_report_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index()->constrained();
            $table->string('reportType')->index();
            $table->dateTime('dataStartTime')->nullable();
            $table->dateTime('dataEndTime')->nullable();
            $table->json('options')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_report_requests');
    }
};
