<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('amazon_order_id')->index()->constrained();
            $table->string('ASIN')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ASIN'))");
            $table->string('SellerSKU')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.SellerSKU'))");
            $table->string('OrderItemId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.OrderItemId'))")->index();
            $table->string('Title')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.Title'))");
            $table->string('QuantityOrdered')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.QuantityOrdered'))");
            $table->string('QuantityShipped')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.QuantityShipped'))");
            $table->string('ItemCurrency')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ItemPrice.CurrencyCode'))");
            $table->string('ItemPrice')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ItemPrice.Amount'))");
            $table->string('ShippingPrice')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ShippingPrice.Amount'))");
            $table->string('ItemTax')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ItemTax.Amount'))");
            $table->string('ShippingTax')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ShippingTax.Amount'))");
            $table->string('ShippingDiscount')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ShippingDiscount.Amount'))");
            $table->string('ShippingDiscountTax')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ShippingDiscountTax.Amount'))");
            $table->string('PromotionDiscount')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.PromotionDiscount.Amount'))");
            $table->string('PromotionDiscountTax')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.PromotionDiscountTax.Amount'))");
            $table->string('CODFee')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.CODFee.Amount'))");
            $table->string('CODFeeDiscount')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.CODFeeDiscount.Amount'))");
            $table->string('IsGift')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.IsGift'))");
            $table->string('ConditionNote')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ConditionNote'))");
            $table->string('ConditionId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ConditionId'))");
            $table->string('ConditionSubtypeId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ConditionSubtypeId'))");
            $table->string('ScheduledDeliveryStartDate')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ScheduledDeliveryStartDate'))");
            $table->string('ScheduledDeliveryEndDate')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.ScheduledDeliveryEndDate'))");
            $table->string('PriceDesignation')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.PriceDesignation'))");
            $table->string('SerialNumberRequired')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.SerialNumberRequired'))");
            $table->string('IsTransparency')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.IsTransparency'))");
            $table->string('IossNumber')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.IossNumber'))");
            $table->string('StoreChainStoreId')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.StoreChainStoreId'))");
            $table->string('DeemedResellerCategory')->storedAs("JSON_UNQUOTE(json_extract(json_object,'$.DeemedResellerCategory'))");
            $table->json('json_object');
            $table->unique(['amazon_order_id', 'OrderItemId']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_order_items');
    }
};
