<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('amazon_products', function (Blueprint $table) {
            $table->json('catalog_data')->nullable()->after('json_object');
            $table->string('brand')->after('catalog_data')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.summaries[0].brand'))");
            $table->string('manufacturer')->after('brand')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.summaries[0].manufacturer'))");
            $table->string('model')->after('manufacturer')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.summaries[0].modelNumber'))");
            $table->string('part_number')->after('model')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.summaries[0].partNumber'))");
            $table->string('product_type')->after('part_number')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.productTypes[0].productType'))");
            $table->string('sales_rank')->after('product_type')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.salesRanks[0].displayGroupRanks[0].rank'))");
            $table->string('color')->after('sales_rank')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.summaries[0].color'))");
            $table->string('package_length')->after('color')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].package.length.value'))");
            $table->string('package_width')->after('package_length')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].package.width.value'))");
            $table->string('package_height')->after('package_width')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].package.height.value'))");
            $table->string('package_dimensions_unit')->after('package_height')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].package.length.unit'))");
            $table->string('package_weight')->after('package_dimensions_unit')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].package.weight.value'))");
            $table->string('package_weight_unit')->after('package_weight')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.dimensions[0].package.weight.unit'))");
            $table->string('main_image')->after('package_weight_unit')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.images[0].images[0].link'))");
            $table->string('browse_classification')->after('main_image')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.summaries[0].browseClassification.displayName'))");
            $table->string('website_group_name')->after('browse_classification')->storedAs("JSON_UNQUOTE(json_extract(catalog_data,'$.catalog_data.summaries[0].websiteDisplayGroupName'))");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('amazon_products', function (Blueprint $table) {
            $table->dropColumn('brand');
            $table->dropColumn('manufacturer');
            $table->dropColumn('model');
            $table->dropColumn('part_number');
            $table->dropColumn('product_type');
            $table->dropColumn('sales_rank');
            $table->dropColumn('color');
            $table->dropColumn('package_length');
            $table->dropColumn('package_width');
            $table->dropColumn('package_height');
            $table->dropColumn('package_dimensions_unit');
            $table->dropColumn('package_weight');
            $table->dropColumn('package_weight_unit');
            $table->dropColumn('main_image');
            $table->dropColumn('browse_classification');
            $table->dropColumn('website_group_name');
            $table->dropColumn('catalog_data');
        });
    }
};
