<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('amazon_reports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('integration_instance_id')->index()->constrained();
            $table->string('reportId')->unique()->nullable();
            $table->string('reportType')->index();
            $table->dateTime('dataStartTime')->nullable();
            $table->dateTime('dataEndTime')->nullable();
            $table->json('options')->nullable();
            $table->string('reportScheduledId')->nullable();
            $table->dateTime('createdTime')->nullable();
            /** ENUM */
            $table->string('processingStatus')->nullable();
            /** end ENUM */
            $table->dateTime('processingStartTime')->nullable();
            $table->dateTime('processingEndTime')->nullable();
            $table->string('reportDocumentId')->nullable();
            $table->json('marketplaceIds')->nullable();
            $table->string('filename')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('amazon_reports');
    }
};
