<?php

namespace Modules\Amazon\Database\Factories;

use App\Models\NominalCode;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReportSettlementTypeMapping;

class AmazonReportSettlementTypeMappingFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonReportSettlementTypeMapping::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'transaction_type' => $this->faker->sentence(10),
            'amount_type' => $this->faker->sentence(10),
            'amount_description' => $this->faker->sentence(10),
            'nominal_code_id' => NominalCode::factory(),
        ];
    }
}
