<?php

namespace Modules\Amazon\Database\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFinancialEventGroup;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;
use Modules\Amazon\Entities\AmazonReportSettlementData;

class AmazonReportSettlementDataFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonReportSettlementData::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'amazon_report_id' => AmazonReport::factory(),
            'amazon_financial_event_group_id' => AmazonFinancialEventGroup::factory(),
            'checksum' => $this->faker->sentence(10),
            'json_object' => [
                'settlement_id' => $this->faker->sentence(10),
                'transaction_type' => $this->faker->sentence(10),
                'order_id' => $this->faker->sentence(10),
                'merchant_order_id' => $this->faker->sentence(10),
                'adjustment_id' => $this->faker->sentence(10),
                'shipment_id' => $this->faker->sentence(10),
                'marketplace_name' => $this->faker->sentence(10),
                'amount_type' => $this->faker->sentence(10),
                'amount_description' => $this->faker->sentence(10),
                'amount' => $this->faker->sentence(10),
                'fulfillment_id' => $this->faker->sentence(10),
                'posted_date' => Carbon::now()->toDateString(),
                'posted_date_time' => Carbon::now(),
                'order_item_code' => $this->faker->sentence(10),
                'merchant_order_item_id' => $this->faker->sentence(10),
                'merchant_adjustment_item_id' => $this->faker->sentence(10),
                'sku' => $this->faker->sentence(10),
                'quantity_purchased' => $this->faker->numberBetween(1, 10),
                'promotion_id' => $this->faker->sentence(10),
            ],
        ];
    }
}
