<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\Amazon\Entities\AmazonNewFbaInboundShipment;
use Modules\Amazon\Entities\AmazonNewFbaInboundShipmentItem;
use Modules\Amazon\Enums\Entities\AmazonFbaInboundShipmentItemLabelOwnerEnum;

class AmazonNewFbaInboundShipmentItemFactory extends Factory
{
    protected $model = AmazonNewFbaInboundShipmentItem::class;

    public function definition(): array
    {
        return [
            'amazon_new_fba_inbound_shipment_id' => AmazonNewFbaInboundShipment::factory(),
            'json_object' => [
                'msku' => $this->faker->word(),
                'quantity' => $this->faker->word(),
                'fnsku' => $this->faker->word(),
                'asin' => $this->faker->word(),
                'labelOwner' => $this->faker->randomElement(AmazonFbaInboundShipmentItemLabelOwnerEnum::values()),
                'prepInstructions' => $this->faker->words(),
            ],
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
