<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonNewFbaInboundPlan;
use Modules\Amazon\Enums\Entities\FbaInboundPlanStatusEnum;

class AmazonNewFbaInboundPlanFactory extends Factory
{
    protected $model = AmazonNewFbaInboundPlan::class;

    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'json_object' => [
                'inboundPlanId' => $this->faker->word(),
                'name' => $this->faker->word(),
                'sourceName' => $this->faker->word(),
                'status' => $this->faker->randomElement(FbaInboundPlanStatusEnum::values()),
                'shipments' => $this->faker->words(),
                'sourceAddress' => $this->faker->words(),
                'lastUpdatedAt' => now(),
                'createdAt' => now(),
            ],
            'created_at' => now(),
            'updated_at' => now(),
        ];
    }
}
