<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\Amazon\Entities\AmazonLedgerDetail;

class AmazonLedgerDetailFactory extends Factory
{
    protected $model = AmazonLedgerDetail::class;

    public function definition(): array
    {
        return [
            'amazon_fba_report_inventory_ledger_id' => $this->faker->randomNumber(),
            'detail_id' => $this->faker->randomNumber(),
            'detail_type' => $this->faker->word(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
