<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;
use Modules\Amazon\Entities\AmazonFulfillmentOrder;
use Modules\Amazon\Entities\AmazonFulfillmentOrderItem;

class AmazonFulfillmentOrderItemFactory extends Factory
{
    protected $model = AmazonFulfillmentOrderItem::class;

    public function definition(): array
    {
        return [
            'amazon_fulfillment_order_id' => AmazonFulfillmentOrder::factory(),
            'json_object' => [
                'sellerSku' => $this->faker->word(),
                'sellerFulfillmentOrderItemId' => $this->faker->word(),
                'quantity' => $this->faker->randomNumber(),
                'giftMessage' => $this->faker->word(),
                'displayableComment' => $this->faker->word(),
                'fulfillmentNetworkSku' => $this->faker->word(),
                'perUnitPriceCurrencyCode' => $this->faker->word(),
                'perUnitPriceCurrencyValue' => $this->faker->randomFloat(),
                'perUnitTaxCurrencyCode' => $this->faker->word(),
                'perUnitTaxValue' => $this->faker->randomFloat(),
                'perUnitDeclaredValueCurrencyCode' => $this->faker->word(),
                'perUnitDeclaredValueValue' => $this->faker->randomFloat(),
                'orderItemDisposition' => $this->faker->word(),
                'cancelledQuantity' => $this->faker->randomNumber(),
                'unfulfillableQuantity' => $this->faker->randomNumber(),
                'estimatedShipDate' => $this->faker->word(),
                'estimatedArrivalDate' => $this->faker->word(),
            ],
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
