<?php

namespace Modules\Amazon\Database\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFinancialEventGroup;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

class AmazonFinancialEventGroupFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFinancialEventGroup::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'json_object' => [
                'FinancialEventGroupId' => $this->faker->unique()->numberBetween(),
                'ProcessingStatus' => 'Open',
                'OriginalTotal' => [
                    'CurrencyCode' => 'USD',
                    'CurrencyAmount' => $this->faker->randomFloat(),
                ],
                'ConvertedTotal' => [
                    'CurrencyCode' => 'USD',
                    'CurrencyAmount' => $this->faker->randomFloat(),
                ],
                'BeginningBalance' => [
                    'CurrencyCode' => 'USD',
                    'CurrencyAmount' => $this->faker->randomFloat(),
                ],
                'FinancialEventGroupStart' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
                'FinancialEventGroupEnd' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
            ],
            'FinancialEventGroupStart_datetime' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
            'FinancialEventGroupEnd_datetime' => Carbon::parse($this->faker->dateTimeBetween('-1 year'))->toIso8601String(),
        ];
    }
}
