<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFinancialAdjustmentEvent;
use Modules\Amazon\Entities\AmazonIntegrationInstance;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Modules\Amazon\Entities\AmazonFinancialAdjustmentEvent>
 */
class AmazonFinancialAdjustmentEventFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFinancialAdjustmentEvent::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'json_object' => [

            ],
        ];
    }
}
