<?php

namespace Modules\Amazon\Database\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFbaReportShipment;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;

class AmazonFbaReportShipmentFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFbaReportShipment::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'amazon_report_id' => AmazonReport::factory(),
            'event_datetime' => Carbon::parse($this->faker->date())->toIso8601String(),
            'json_object' => [
                'shipment_date' => Carbon::parse($this->faker->date())->toIso8601String(),
                'reporting_date' => Carbon::parse($this->faker->date())->toIso8601String(),
                'amazon_order_id' => $this->faker->word(),
                'sku' => $this->faker->word(),
                'product_name' => $this->faker->word(),
                'quantity_shipped' => $this->faker->randomNumber(),
                'fulfillment_center_id' => $this->faker->word(),
            ],
            'checksum' => $this->faker->word(),
        ];
    }
}
