<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFbaReportInventory;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Entities\AmazonReport;

class AmazonFbaReportInventoryFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFbaReportInventory::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'amazon_report_id' => AmazonReport::factory(),
            'json_object' => [
                'sku' => $this->faker->word(),
                'fnsku' => $this->faker->word(),
                'product_name' => $this->faker->word(),
                'condition' => $this->faker->word(),
                'your_price' => $this->faker->randomFloat(2, 0, 100),
                'mfn_listing_exists' => 'Yes',
                'mfn_fulfillable_quantity' => $this->faker->randomNumber(),
                'afn_listing_exists' => 'Yes',
                'afn_warehouse_quantity' => $this->faker->randomNumber(),
                'afn_fulfillable_quantity' => $this->faker->randomNumber(),
                'afn_unsellable_quantity' => $this->faker->randomNumber(),
                'afn_reserved_quantity' => $this->faker->randomNumber(),
                'afn_total_quantity' => $this->faker->randomNumber(),
                'per_unit_volume' => $this->faker->randomFloat(2, 0, 100),
                'afn_inbound_working_quantity' => $this->faker->randomNumber(),
                'afn_inbound_shipped_quantity' => $this->faker->randomNumber(),
                'afn_inbound_receiving_quantity' => $this->faker->randomNumber(),
                'afn_researching_quantity' => $this->faker->randomNumber(),
                'afn_reserved_future_supply' => $this->faker->randomNumber(),
                'afn_future_supply_buyable' => $this->faker->randomNumber(),
            ],
            'checksum' => $this->faker->word(),
        ];
    }
}
