<?php

namespace Modules\Amazon\Database\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFbaInboundShipment;
use Modules\Amazon\Entities\AmazonFbaInboundShipmentItem;

class AmazonFbaInboundShipmentItemFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFbaInboundShipmentItem::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'amazon_fba_inbound_shipment_id' => AmazonFbaInboundShipment::factory(),
            'json_object' => [
                'SellerSKU' => $this->faker->word(),
                'FulfillmentNetworkSKU' => $this->faker->word(),
                'QuantityShipped' => $this->faker->randomNumber(),
                'QuantityReceived' => $this->faker->randomNumber(),
                'QuantityInCase' => $this->faker->randomNumber(),
                'ReleaseDate' => Carbon::parse($this->faker->date()),
            ],
        ];
    }
}
