<?php

namespace Modules\Amazon\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Amazon\Entities\AmazonFbaInboundShipment;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Enums\Entities\FbaInboundShipmentStatusEnum;

class AmazonFbaInboundShipmentFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = AmazonFbaInboundShipment::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /** @var AmazonIntegrationInstance $amazonIntegrationInstance */
        $amazonIntegrationInstance = AmazonIntegrationInstance::query()->first();

        return [
            'integration_instance_id' => $amazonIntegrationInstance->id,
            'json_object' => [
                'ShipmentId' => $this->faker->word(),
                'ShipmentName' => $this->faker->word(),
                'ShipFromName' => $this->faker->word(),
                'DestinationFulfillmentCenterId' => $this->faker->word(),
                'ShipmentStatus' => $this->faker->randomElement(FbaInboundShipmentStatusEnum::STATUSES_ACTIVE),
                'LabelPrepType' => $this->faker->word(),
                'BoxContentsSource' => $this->faker->word(),
            ],
        ];
    }
}
