<?php

namespace Modules\Amazon\Data;

use App\Abstractions\Integrations\Data\StoreSalesChannelIntegrationDataInterface;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class UpdateAmazonIntegrationData extends Data implements StoreSalesChannelIntegrationDataInterface
{
    public function __construct(
        public string|Optional $name,
        public AmazonConnectionSettingsData|Optional $connection_settings,
        public AmazonIntegrationSettingsData|Optional $integration_settings,
        public bool|Optional $is_automatic_sync_enabled = false,
    )
    {
    }
}