<?php

namespace Modules\Amazon\Data;

use Carbon\Carbon;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Enums\Entities\AmazonReportTypeEnum;
use Spatie\LaravelData\Data;

class RequestAmazonReportData extends Data
{
    public function __construct(
        public AmazonIntegrationInstance $amazonIntegrationInstance,
        public AmazonReportTypeEnum $report_type,
        public ?Carbon $data_start_date = null,
        public ?Carbon $data_end_date = null,
        public ?array $options = null,
        public ?array $marketplace_ids = null,
        public bool $createImmediately = true,
    )
    {
    }
}
