<?php

namespace Modules\Amazon\Data;

use App\Models\Product;
use Modules\Amazon\Entities\AmazonFbaReportRemovalOrder;
use Spatie\LaravelData\Data;

class RemovalOrderLineData extends Data
{
    public function __construct(
        public AmazonFbaReportRemovalOrder $removalOrder,
        public string $sku,
        public string $fnsku,
        public string $disposition,
        public int $requested_quantity,
        public int $cancelled_quantity = 0,
        public int $disposed_quantity = 0,
        public int $shipped_quantity = 0,
        public int $in_process_quantity = 0,
        public float $removal_fee = 0,
        public string $currency = 'USD',
        public ?int $product_id = null,
        public ?bool $is_unknown_item = false,
    )
    {
    }
}
