<?php

namespace Modules\Amazon\Data;

use Carbon\Carbon;
use Modules\Amazon\Enums\Entities\AmazonReportTypeEnum;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class AmazonReportRequestData extends Data
{
    public function __construct(
        public int|Optional $id,
        public ?AmazonReportTypeEnum $reportType,
        public Optional|string|null $dataStartTime,
        public Optional|string|null $dataEndTime,
        public array|null|Optional $options,
        public array|null|Optional $marketplaceIds,
        public Carbon|Optional $created_at,
        public Carbon|Optional $updated_at,
    )
    {
        foreach ($this->getDateFields() as $dateField) {
            if (!$this->{$dateField} instanceof Optional) {
                $this->{$dateField} = Carbon::parse($this->{$dateField})->toDateTimeString();
            }
        }
    }

    private function getDateFields(): array
    {
        return [
            'dataStartTime',
            'dataEndTime',
        ];
    }
}
