<?php

namespace Modules\Amazon\Data;

use App\Abstractions\Integrations\Data\AbstractSalesChannelOrderData;
use Carbon\Carbon;

class AmazonOrderData extends AbstractSalesChannelOrderData
{
    public function __construct(
        public array $json_object,
    ) {
        parent::__construct($json_object);
        $this->json_object['BuyerInfo'] = encryptArray(@$json_object['BuyerInfo']);

        $this->json_object['ShippingAddress'] = encryptArray(@$json_object['ShippingAddress'], [
            'AddressLine1',
            'AddressLine2',
            'AddressLine3',
        ]);

        //Convert to UTC columns
        $this->json_object['EarliestShipDateUtc'] = $this->json_object['EarliestShipDate'] ? Carbon::parse($this->json_object['EarliestShipDate'])->toDateTimeString() : null;
        $this->json_object['LatestShipDateUtc'] = $this->json_object['LatestShipDate'] ? Carbon::parse($this->json_object['LatestShipDate'])->toDateTimeString() : null;
        $this->json_object['PurchaseDateUtc'] = $this->json_object['PurchaseDate'] ? Carbon::parse($this->json_object['PurchaseDate'])->toDateTimeString() : null;
        $this->json_object['LastUpdateDateUtc'] = $this->json_object['LastUpdateDate'] ? Carbon::parse($this->json_object['LastUpdateDate'])->toDateTimeString() : null;
    }
}
