<?php

namespace Modules\Amazon\Console;

use Illuminate\Console\Command;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\SyncAmazonInventoryJob;
use Modules\Amazon\Repositories\AmazonIntegrationInstanceRepository;

class SyncAmazonInventoryCommand extends Command
{
    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(private readonly AmazonIntegrationInstanceRepository $integrationInstanceRepository)
    {
        parent::__construct();
    }

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:inventory:sync {--integrationInstanceId=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync inventory job';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $query = $this->integrationInstanceRepository
            ->all($this->option('integrationInstanceId') ? $this->option('integrationInstanceId') : null);

        $query
            ->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
                SyncAmazonInventoryJob::dispatch(
                    $amazonIntegrationInstance
                );
            });

        return 0;
    }
}
