<?php

namespace Modules\Amazon\Console;

use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\ApiDataTransferObjects\AmazonGetReportsAdt;
use Modules\Amazon\Enums\Entities\AmazonReportTypeEnum;
use Modules\Amazon\Jobs\RefreshAmazonSettlementReportsJob;
use Throwable;

class RefreshAmazonSettlementReportsCommand extends AbstractAmazonCommand
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'amazon:reports:refresh-settlement {integrationInstanceId?}
                            {--d|days= : Days of data}
                            {--s|startDate= : Report start date (2019-10-31)}
                            {--e|endDate= : Report end date (2019-10-31)}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refresh Amazon Settlement Reports';

    /**
     * Execute the console command.
     *
     * @throws Throwable
     */
    public function handle(): void
    {
        $parameters = new AmazonGetReportsAdt(
            reportType: AmazonReportTypeEnum::SETTLEMENT_REPORT,
            start: $this->option('startDate'),
            end: $this->option('endDate'),
            days: $this->option('days'),
        );

        foreach ($this->integrationInstanceRepository->all() as $amazonIntegrationInstance) {
            RefreshAmazonSettlementReportsJob::dispatch($amazonIntegrationInstance, $parameters);
        }
    }
}
