<?php

namespace Modules\Amazon\Console;

use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\RefreshAmazonOutboundFulfillmentsJob;

class RefreshAmazonOutboundFulfillmentsCommand extends AbstractAmazonCommand
{
    protected $signature = 'amazon:outbound-fulfillments:refresh {integrationInstanceId?} {queryStartDate?}';

    protected $description = 'Refresh Amazon Outbound Fulfillments';

    public function handle(): void
    {
        $query = $this->integrationInstanceRepository
            ->all($this->argument('integrationInstanceId'));

        $query->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
            dispatch(new RefreshAmazonOutboundFulfillmentsJob($amazonIntegrationInstance, $this->argument('queryStartDate')));
        });

    }
}
