<?php

namespace Modules\Amazon\Console;

use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\CreateAmazonRefreshOrderItemsJobs;

class RefreshAmazonOrderItemsCommand extends AbstractAmazonCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:orders:refresh-items {integrationInstanceId?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Amazon Order Items';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
            CreateAmazonRefreshOrderItemsJobs::dispatch($amazonIntegrationInstance);
        });
    }
}
