<?php

namespace Modules\Amazon\Console;

use Carbon\Carbon;
use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\RefreshAmazonFbaInboundShipmentsJob;

class RefreshAmazonFbaInboundShipmentsCommand extends AbstractAmazonCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:inbound-shipments:refresh {integrationInstanceId?} {--lastUpdatedAfter=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get Amazon FBA Inbound Shipments';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $this->integrationInstances()->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
            RefreshAmazonFbaInboundShipmentsJob::dispatch($amazonIntegrationInstance, $this->option('lastUpdatedAfter') ? Carbon::parse($this->option('lastUpdatedAfter')) : null);
        });
    }
}
