<?php

namespace Modules\Amazon\Console;

use Illuminate\Console\Command;
use Modules\Amazon\Entities\AmazonReport;
use Modules\Amazon\Jobs\ProcessAmazonReportsJob;
use Modules\Amazon\Repositories\AmazonReportRepository;

class ProcessAmazonReportsCommand extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'amazon:reports:process {--reportId= : Report ID to process}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process amazon reports (Import and Handle)';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(private readonly AmazonReportRepository $amazonReportRepository)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        if ($reportId = $this->option('reportId')) {
            ProcessAmazonReportsJob::dispatch(
                $this->amazonReportRepository->getFromReportId($reportId)
            );
        } else {
            $this->amazonReportRepository
                ->getUnprocessedReports()
                ->each(function (AmazonReport $amazonReport) {
                    ProcessAmazonReportsJob::dispatch($amazonReport);
                });
        }

    }
}
