<?php

namespace Modules\Amazon\Console;

use Modules\Amazon\Abstractions\AbstractAmazonCommand;
use Modules\Amazon\Entities\AmazonIntegrationInstance;
use Modules\Amazon\Jobs\GetAmazonOrderJob;

class GetAmazonOrderCommand extends AbstractAmazonCommand
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'amazon:order:get {AmazonOrderId} {integrationInstanceId?} ';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Get A Single Amazon Order (And Items)';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $query = $this->integrationInstanceRepository
            ->all($this->argument('integrationInstanceId'));

        $query
            ->each(function (AmazonIntegrationInstance $amazonIntegrationInstance) {
                GetAmazonOrderJob::dispatch($amazonIntegrationInstance, $this->argument('AmazonOrderId'));
            });
    }
}
